<?php
    defined('BASEPATH') OR exit('No direct script access allowed');
    
    class PaymentController extends CI_Controller 
    {
        public function __construct() 
        {
            parent::__construct();
            $this->load->library('session');
            $this->load->helper('url');
            
			$this->load->database();
			$this->load->helper('url');
            /*$this->load->model('cart/CartModel');
			$this->load->model('company/CompanyModel');
			$this->load->model('menu/MenuModel');
			$this->load->model('subMenu/SubMenuModel');
			$this->load->model('customer/CustomerModel');
			$this->load->model('order/OrderModel');
			$this->load->model('orderDetails/OrderDetailsModel');*/
		
			$this->load->model('bookingDetails/BookingDetailsModel');
			$this->load->model('eventDetails/EventDetailsModel');
			
        }
        
    	public function index()
    	{   
    	    if($this->session->userdata('withRegistrationFlag') == '1')
    	    {
        	    $bookingID                  = $this->session->userdata('bookingID');
        	    $bookingResult              = $this->BookingDetailsModel->getBooking($bookingID);
        	    $bookingDetailsResult       = $this->BookingDetailsModel->getBookingDetails($bookingID);
    
        	    $this->load->view('payment/Payment', ['bookingResult'=>$bookingResult, 'bookingDetailsResult'=>$bookingDetailsResult]);
    	    }
    	    else if($this->session->userdata('withRegistrationFlag') == '2')
    	    {
        	    $bookingID                  = $this->session->userdata('bookingID');
        	    $bookingResult              = $this->BookingDetailsModel->getBooking($bookingID);
        	    $bookingDetailsResult       = $this->BookingDetailsModel->getBookingDetails($bookingID);
    
        	    $this->load->view('payment/Payment', ['bookingResult'=>$bookingResult, 'bookingDetailsResult'=>$bookingDetailsResult]);
    	    }
    	    else
    	    {
    	        $participantID                  = $this->session->userdata('participantID');
        	    $participantResult              = $this->BookingDetailsModel->getParticipant($participantID);
    	        $this->load->view('payment/Payment', ['participantResult'=>$participantResult]);
    	    }
    	}
		
		public function bookingPaymentStatus()
    	{
			if($this->input->post('txtBookingID') !="" && $this->input->post('txtPayment') !="" && $this->input->post('txtParticipantID'))
			{
				$result = $this->BookingDetailsModel->updateBookingPaymentStatus($this->input->post('txtBookingID'), $this->input->post('txtPayment')); 
				$result = $this->BookingDetailsModel->updateParticipantPaymentStatus($this->input->post('txtParticipantID'), $this->input->post('txtPayment')); 

				if($result == 1)
				{
				    $bookingResult              = $this->BookingDetailsModel->getBooking($this->input->post('txtBookingID'));
        	        $bookingDetailsResult       = $this->BookingDetailsModel->getBookingDetails($this->input->post('txtBookingID'));
        	        $eventDetailsResult         = $this->EventDetailsModel->getEventDetails();
        	        $participantResult              = $this->BookingDetailsModel->getParticipant($this->input->post('txtParticipantID'));
        	        
        	        for($j=0; $j<count($bookingDetailsResult); $j++)
					{ 
            	        for($i=0; $i<count($eventDetailsResult); $i++)
    					{
    					    if($eventDetailsResult[$i]['eventDetailsID'] == $bookingDetailsResult[$j]['eventDetailsID'])
    					    {
        					    $eventDetailsID             = $eventDetailsResult[$i]['eventDetailsID'];
        					    $day1MorningAvailableSeats  = $eventDetailsResult[$i]['day1MorningAvailableSeats'];
        					    $day1EveningAvailableSeats  = $eventDetailsResult[$i]['day1EveningAvailableSeats'];
        					    $day2MorningAvailableSeats  = $eventDetailsResult[$i]['day2MorningAvailableSeats'];
        					    $day2EveningAvailableSeats  = $eventDetailsResult[$i]['day2EveningAvailableSeats'];
        					    $day3MorningAvailableSeats  = $eventDetailsResult[$i]['day3MorningAvailableSeats'];
        					    
        					    if(($eventDetailsResult[$i]['day1Morning'] == '1') && ($bookingDetailsResult[$j]['day1Morning'] == '1'))
        					    {
        					        $day1MorningFlag    = 1;
        					        $day1MorningAvailableSeats = $day1MorningAvailableSeats - 1;
        					    }
        					    
        					    if(($eventDetailsResult[$i]['day1Evening'] == '1') && ($bookingDetailsResult[$j]['day1Evening'] == '1'))
        					    {
        					        $day1EveningFlag    = 1;
        					        $day1EveningAvailableSeats = $day1EveningAvailableSeats - 1;
        					    }
        					    
        					    if(($eventDetailsResult[$i]['day2Morning'] == '1') && ($bookingDetailsResult[$j]['day2Morning'] == '1'))
        					    {
        					        $day2MorningFlag    = 1;
        					        $day2MorningAvailableSeats = $day2MorningAvailableSeats - 1;
        					    }
        					    
        					    if(($eventDetailsResult[$i]['day2Evening'] == '1') && ($bookingDetailsResult[$j]['day2Evening'] == '1'))
        					    {
        					        $day2EveningFlag    = 1;
        					        $day2EveningAvailableSeats = $day2EveningAvailableSeats - 1;
        					    }
        					    
        					    if(($eventDetailsResult[$i]['day3Morning'] == '1') &&  ($bookingDetailsResult[$j]['day3Morning'] == '1'))
        					    {
        					        $day3MorningFlag    = 1;
        					        $day3MorningAvailableSeats = $day3MorningAvailableSeats - 1;
        					    }
        					    
        					    if($day1MorningFlag == 1 || $day1EveningFlag == 1 || $day2MorningFlag == 1 || $day2EveningFlag == 1 || $day3MorningFlag == 1)
        					    {
            					    $event = array( 
                        								'day1MorningAvailableSeats' 	=> $day1MorningAvailableSeats,
                        								'day1EveningAvailableSeats' 	=> $day1EveningAvailableSeats,
                        								'day2MorningAvailableSeats' 	=> $day2MorningAvailableSeats,
                        								'day2EveningAvailableSeats' 	=> $day2EveningAvailableSeats,
                        								'day3MorningAvailableSeats' 	=> $day3MorningAvailableSeats
                        							);
                        							
                        		    $result = $this->EventDetailsModel->updateEventDetails($event, $eventDetailsResult[$i]['eventDetailsID']); 
        					    }
    					    }
    					}
					}
					
					$this->sendMail($participantResult, '1');
					
					$bookingMail = array($bookingResult, $bookingDetailsResult, $participantResult);
    				$this->sendMail($bookingMail, '2');
    				//	exit;
					//echo "<pre>"; print_r($event);exit;
					echo "<script>alert('Your Order Place successfully... ');
							window.location.href='".base_url()."index.php/payment/PaymentController';
						</script>";
				}
				else
				{
				    echo "<script>alert('Your Order Not Place. Please Try Again...');
							window.location.href='".base_url()."index.php/payment/PaymentController';
						</script>";
				}
            }
    	}
    	
    	public function participantPaymentStatus()
    	{
			if($this->input->post('txtParticipantID') !="" &&	$this->input->post('txtPayment') !="")
			{
				$result = $this->BookingDetailsModel->updateParticipantPaymentStatus($this->input->post('txtParticipantID'), $this->input->post('txtPayment')); 

				if($result == 1)
				{
				    $participantResult = $this->BookingDetailsModel->getParticipant($this->input->post('txtParticipantID'));
				    $this->sendMail($participantResult, '1');
				    
					echo "<script>alert('Your Order Placed Successfully... ');
							window.location.href='".base_url()."index.php/payment/PaymentController';
						</script>";
				}
				else
				{
				    echo "<script>alert('Your Order Not Place. Please Try Again...');
							window.location.href='".base_url()."index.php/payment/PaymentController';
						</script>";
				}
            }
    	}
    	
    	public function sendMail($prop, $flag)
        { 
            if($flag == '1')
            {
                $to         = 'deshmukh57@yahoo.in,usp.eventbook@gmail.com,uskpune.razorpay@gmail.com,'.$prop['0']['mailID'];
                $subject    = "Urban Sketchers Pune Participant Registration";
                
                $status  = "Unkown";
                $payment = "Unkown";
                $additionalMessage = "";
                
                if($prop['0']['status'] == '0')
                {
                    $status = "Pending";
                    $additionalMessage = "You can't use this ID for Workshop Bookings. Please register again with successful transaction.";
                }
                else if($prop['0']['status'] == '1')
                {
                    $status = "Booked";
                    $additionalMessage = "Please Use this Registration ID for further Workshop Booking.";
                }
                
                if($prop['0']['payment'] == '1')
                {
                    $payment = "Online Payment";
                }
                else if($prop['0']['payment'] == '0')
                {
                    $payment = "Payment Issue";
                }
                
                $message = "
                <html>
                    <head>
                        <title>Urban Sketchers Pune Participant Registration Details</title>
                        <style>
                            table
                            {
                                width: 100%;
                            }
                            
                            th
                            {
                                border: 1px solid gray;
                                padding: 10px;
                                /*color: #FFF;
                                background: #0160aa;*/
                            }
                            
                            td
                            {
                                border: 1px solid gray;
                                padding: 10px;
                            }
                            
                            .colorHeading
                            {
                                background: #333333;
                            }
                        </style>
                    </head>
                    <body>
                        <table>
                            <tr>
                                <th colspan='2' class='colorHeading'></th>
                            </tr>
                            <tr>
                                <td colspan='2'>
                                    <center>
                                        <img alt='Logo' src='https://nandd.co/urbansketchers/backoffice/assets/img/mainLogo.png'/>
                                        <h3>Urban Sketchers Pune Participant Registration Details</h3>
                                    </center>
                                </td>
                            </tr>
                            <tr>
                                <th style='width:50%'>Participant ID : </th>
                                <td style='width:50%'>USP".$prop['0']['participantID']."</td>
                            </tr>
    						<tr>
                                <th>First Name : </th>
                                <td>".$prop['0']['firstName']."</td>
                            </tr>
                            <tr>
                                <th>Last Name : </th>
                                <td>".$prop['0']['lastName']."</td>
                            </tr>
    						<tr>
                                <th>Contact Number : </th>
                                <td>".$prop['0']['contactNumber']."</td>
                            </tr>
    						<tr>    
                                <th>Email Address : </th>
                                <td>".$prop['0']['mailID']."</td>
                            </tr>
                            <tr>
                                <th>Current City : </th>
                                <td>".$prop['0']['groupBranchCity']."</td>
                            </tr>
    						<tr>    
                                <th>Country : </th>
                                <td>".$prop['0']['address']."</td>
                            </tr>
                            <tr>
                                <th>Amount : </th>
                                <td>500</td>
                            </tr>
                            <tr>
                                <th>Booking Status : </th>
                                <td>".$status." (".$additionalMessage.")</td>
                            </tr>
    						<tr>
                                <th>Payment Status : </th>
                                <td>".$payment."</td>
                            </tr>
                            <tr>
                                <th colspan='2' class='colorHeading'></th>
                            </tr>
                        </table>
                    </body>
                </html>
                ";
            }
            else if($flag == '2')
            {
                $to                 = 'deshmukh57@yahoo.in,usp.eventbook@gmail.com,uskpune.razorpay@gmail.com,'.$prop['2']['0']['mailID'];
                $subject            = "Urban Sketchers Pune Workshop Booking Details";
                $tatalAmountForMail = 0;
                
                if($prop['0']['0']['withRegistrationFlag'] == '1')
                {
                    $tatalAmountForMail = ($prop['0']['0']['totalAmount'] - 500);
                }
                else if($prop['0']['0']['withRegistrationFlag'] == '2')
                {
                    $tatalAmountForMail = $prop['0']['0']['totalAmount'];
                }
                else
                {
                    $tatalAmountForMail = 500;
                }
                    
                $message = "
                <html>
                    <head>
                        <title>Urban Sketchers Pune Workshop Booking Details</title>
                        <style>
                            
                            table
                            {
                                width: 100%;
                            }
                            
                            th
                            {
                                border: 1px solid gray;
                                padding: 10px;
                                /*color: #FFF;
                                background: #0160aa;*/
                            }
                            
                            td
                            {
                                border: 1px solid gray;
                                padding: 10px;
                            }
                            
                            .colorHeading
                            {
                                background: #333333;
                            }
                        </style>
                    </head>
                    <body>
                        <table>";
                        
                        $status  = "Unkown";
                        $payment = "Unkown";
                        
                        if($prop['2']['0']['status'] == '0')
                        {
                            $status = "Pending";
                            $additionalMessage = "You can't use this ID for Workshop Bookings. Please register again with successful transaction.";
                        }
                        else if($prop['2']['0']['status'] == '1')
                        {
                            $status = "Booked";
                            $additionalMessage = "Please Use this Registration ID for further Workshop Booking.";
                        }
                        
                        if($prop['2']['0']['payment'] == '1')
                        {
                            $payment = "Online Payment";
                        }
                        else if($prop['2']['0']['payment'] == '0')
                        {
                            $payment = "Payment Issue";
                        }
                        
                        $BookingDetails = "";
                        
                        if(count($prop['1']) > 0)
                        {
                            for($j=0; $j < count($prop['1']); $j++)
    				        { 
    				            if($prop['1'][$j]['day1Morning']=='1')
    				            {
    				                $BookingDetails .= "Day 1 (".$prop['1'][$j]['InstructorName']." - Morning Batch) : Rs. 1500/-<br>";
    				            }
    				            
    				            if($prop['1'][$j]['day1Evening']=='1')
    				            {
    				                $BookingDetails .= "Day 1 (".$prop['1'][$j]['InstructorName']." - Evening Batch) : Rs. 1500/-<br>";
    				            }
    				            
    				            if($prop['1'][$j]['day2Morning']=='1')
    				            {
    				                $BookingDetails .= "Day 2 (".$prop['1'][$j]['InstructorName']." - Morning Batch) : Rs. 1500/-<br>";
    				            }
    				            
    				            if($prop['1'][$j]['day2Evening']=='1')
    				            {
    				                $BookingDetails .= "Day 2 (".$prop['1'][$j]['InstructorName']." - Evening Batch) : Rs. 1500/-<br>";
    				            }
    				            
    				            if($prop['1'][$j]['day3Morning']=='1')
    				            {
    				                $BookingDetails .= "Day 3 (".$prop['1'][$j]['InstructorName']." - Morning Batch) : Rs. 1500/-<br>";
    				            }
    				            
    				            if($prop['1'][$j]['day3Evening']=='1')
    				            {
    				                $BookingDetails .= "Day 3 (".$prop['1'][$j]['InstructorName']." - Evening Batch) : Rs. 1500/-<br>";
    				            }
    				        }
                        }
                
                $message .= "
                            <tr>
                                <th colspan='2' class='colorHeading'></th>
                            </tr>
                            <tr>
                                <td colspan='2'>
                                    <center>
                                        <img alt='Logo' src='https://nandd.co/urbansketchers/backoffice/assets/img/mainLogo.png'/>
                                        <h3>Urban Sketchers Pune Workshop Booking Details</h3>
                                    </center>
                                </td>
                            </tr>
                            <tr>
                                <th style='width:50%'>Participant ID : </th>
                                <td style='width:50%'>USP".$prop['2']['0']['participantID']."</td>
                            </tr>
                            <tr>
                                <th>First Name : </th>
                                <td>".$prop['2']['0']['firstName']."</td>
                            </tr>
                            <tr>
                                <th>Last Name : </th>
                                <td>".$prop['2']['0']['lastName']."</td>
                            </tr>
    						<tr>
                                <th>Contact Number : </th>
                                <td>".$prop['2']['0']['contactNumber']."</td>
                            </tr>
    						<tr>    
                                <th>Email Address : </th>
                                <td>".$prop['2']['0']['mailID']."</td>
                            </tr>
                            <tr>
                                <th>Current City : </th>
                                <td>".$prop['2']['0']['groupBranchCity']."</td>
                            </tr>
    						<tr>    
                                <th>Country : </th>
                                <td>".$prop['2']['0']['address']."</td>
                            </tr>
                            <tr>
                                <th>Booking Details : </th>
                                <td>".$BookingDetails."</td>
                            </tr>
                            <tr>
                                <th>Total Amount : </th>
                                <td></td>
                                <td>".($prop['0']['0']['totalAmount']-500)."</td>
                            </tr>
    						<tr>
                                <th>Booking Status : </th>
                                <td>".$status." (".$additionalMessage.")</td>
                            </tr>
    						<tr>
                                <th>Payment Status : </th>
                                <td>".$payment."</td>
                            </tr>
                            <tr>
                                <th colspan='2' class='colorHeading'></th>
                            </tr>
                        </table>
                    </body>
                </html>
                ";
            }
            
            // Always set content-type when sending HTML email
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            
            // More headers
            //$fromMailID  = $this->session->userdata('fromEmail');
            $fromMailID = "contact@urbansketcherspune.com";
            
            $headers .= "From: ".$fromMailID."" . "\r\n";
            
            $a = mail($to,$subject,$message,$headers);
            
        }
	}
    
?>