<?php

    defined('BASEPATH') OR exit('No direct script access allowed');
    
    class WorkshopBookingController extends CI_Controller 
    {
        public function __construct() 
        {
            parent::__construct();
            $this->load->library('session');
            $this->load->helper('url');
            
			$this->load->database();
			$this->load->model('eventDetails/eventDetailsModel');
			$this->load->model('workshopRegistration/WorkshopRegistrationModel');
			$this->load->model('workshopRegistrationWithBooking/WorkshopRegistrationWithBookingModel');
			
			$this->load->model('bookings/BookingsModel');
			$this->load->model('bookingDetails/BookingDetailsModel');
			
			$this->load->model('eventDetails/EventDetailsModel');
        }
        
        public function index()
    	{
			$eventDetailsResult = $this->eventDetailsModel->getEventDetails();
    	    $this->load->view('workshopBooking/WorkshopBooking', ['eventDetailsResult'=>$eventDetailsResult]);
    	}
    	
    	public function insertWorkshopBooking()
    	{
    	    //print_r($this->input->post());exit;
    	    if(
                $this->input->post('txtRegistrationID')
			)
			{ 
				$participantID      = $this->input->post('txtRegistrationID');
				
				$participantResult  = $this->BookingDetailsModel->getParticipant($participantID);
				
				$participantMail    = array( 
                                                'participantID' 	=> $participantID,
                                                'firstName' 	    => $this->input->post('txtFirstName'),
                                                'lastName' 	        => $this->input->post('txtLastName'),
                                                'contactNumber'	    => $this->input->post('txtContactNumber'),
                                                'mailID'		    => $this->input->post('txtMailID'),
                                                'address' 	        => $this->input->post('txtAddress'),
                                                'groupBranchCity' 	=> $this->input->post('txtGroupBranchCity'),
                                                'status' 	            => '0',
                                                'payment' 	            => '0'
                                            );
                							
				$this->session->set_userdata('participantID', $participantID);
				$this->session->set_userdata('withRegistrationFlag', '2');
			    $booking = array();
			    $event = array();
			    
			    $eventDetailsResult = $this->EventDetailsModel->getEventDetails();
			    
			    $totalAmount = 0;
				
				for($i=0; $i<count($eventDetailsResult); $i++)
				{
				    $instructorTotalAmount = 0; 
				    $day1MorningFlag    = 0;
				    $day1EveningFlag    = 0;
				    $day2MorningFlag    = 0;
				    $day2EveningFlag    = 0;
				    $day3MorningFlag    = 0;
				    
				    $InstructorName = $eventDetailsResult[$i]['InstructorName'];
				    $day1MorningAvailableSeats  = $eventDetailsResult[$i]['day1MorningAvailableSeats'];
				    $day1EveningAvailableSeats  = $eventDetailsResult[$i]['day1EveningAvailableSeats'];
				    $day2MorningAvailableSeats  = $eventDetailsResult[$i]['day2MorningAvailableSeats'];
				    $day2EveningAvailableSeats  = $eventDetailsResult[$i]['day2EveningAvailableSeats'];
				    $day3MorningAvailableSeats  = $eventDetailsResult[$i]['day3MorningAvailableSeats'];
				    
				    if(!empty($this->input->post("chk-day1Morning-".$eventDetailsResult[$i]['eventDetailsID'])))
				    {
				        $day1MorningFlag    = 1;
				        $totalAmount        = $totalAmount + $eventDetailsResult[$i]['amount'];
				        $instructorTotalAmount = $instructorTotalAmount + $eventDetailsResult[$i]['amount'];
				        $day1MorningAvailableSeats = $day1MorningAvailableSeats - 1;
				    }
				    
				    if(!empty($this->input->post("chk-day1Evening-".$eventDetailsResult[$i]['eventDetailsID'])))
				    {
				        $day1EveningFlag    = 1;
				        $totalAmount        = $totalAmount + $eventDetailsResult[$i]['amount'];
				        $instructorTotalAmount = $instructorTotalAmount + $eventDetailsResult[$i]['amount'];
				        $day1EveningAvailableSeats = $day1EveningAvailableSeats - 1;
				    }
				    
				    if(!empty($this->input->post("chk-day2Morning-".$eventDetailsResult[$i]['eventDetailsID'])))
				    {
				        $day2MorningFlag    = 1;
				        $totalAmount        = $totalAmount + $eventDetailsResult[$i]['amount'];
				        $instructorTotalAmount = $instructorTotalAmount + $eventDetailsResult[$i]['amount'];
				        $day2MorningAvailableSeats = $day2MorningAvailableSeats - 1;
				    }
				    
				    if(!empty($this->input->post("chk-day2Evening-".$eventDetailsResult[$i]['eventDetailsID'])))
				    {
				        $day2EveningFlag    = 1;
				        $totalAmount        = $totalAmount + $eventDetailsResult[$i]['amount'];
				        $instructorTotalAmount = $instructorTotalAmount + $eventDetailsResult[$i]['amount'];
				        $day2EveningAvailableSeats = $day2EveningAvailableSeats - 1;
				    }
				    
				    if(!empty($this->input->post("chk-day3Morning-".$eventDetailsResult[$i]['eventDetailsID'])))
				    {
				        $day3MorningFlag    = 1;
				        $totalAmount        = $totalAmount + $eventDetailsResult[$i]['amount'];
				        $instructorTotalAmount = $instructorTotalAmount + $eventDetailsResult[$i]['amount'];
				        $day3MorningAvailableSeats = $day3MorningAvailableSeats - 1;
				    }
				    
				    if($day1MorningFlag == 1 || $day1EveningFlag == 1 || $day2MorningFlag == 1 || $day2EveningFlag == 1 || $day3MorningFlag == 1)
				    {
					    $bookingMail[] = array( 
					                        'InstructorName'=> $InstructorName,
            								'eventDetailsID'=> $eventDetailsResult[$i]['eventDetailsID'],
            								'amount'		=> $instructorTotalAmount,
            								'day1Morning' 	=> $day1MorningFlag,
            								'day1Evening' 	=> $day1EveningFlag,
            								'day2Morning' 	=> $day2MorningFlag,
            								'day2Evening' 	=> $day2EveningFlag,
            								'day3Morning' 	=> $day3MorningFlag,
            								'day3Evening' 	=> 0
            							);
            							
            			$booking[] = array( 
            								'eventDetailsID'=> $eventDetailsResult[$i]['eventDetailsID'],
            								'amount'		=> $instructorTotalAmount,
            								'day1Morning' 	=> $day1MorningFlag,
            								'day1Evening' 	=> $day1EveningFlag,
            								'day2Morning' 	=> $day2MorningFlag,
            								'day2Evening' 	=> $day2EveningFlag,
            								'day3Morning' 	=> $day3MorningFlag,
            								'day3Evening' 	=> 0
            							);
            			
            			/*$event[] = array( 
            								'day1MorningAvailableSeats' 	=> $day1MorningAvailableSeats,
            								'day1EveningAvailableSeats' 	=> $day1EveningAvailableSeats,
            								'day2MorningAvailableSeats' 	=> $day2MorningAvailableSeats,
            								'day2EveningAvailableSeats' 	=> $day2EveningAvailableSeats,
            								'day3MorningAvailableSeats' 	=> $day3MorningAvailableSeats
            							);*/
				    }
				}
				
				if($totalAmount >= 4500)
				{
				    $totalAmount = $totalAmount - ($totalAmount*.10);
				}
				
				$book = array( 
								'participantID' 	    => $participantID,
								'withRegistrationFlag '	=> '2',
								'totalAmount'		    => $totalAmount,
								'status' 	            => '0',
								'payment' 	            => '0'
							);
            							
            	$result = $this->BookingsModel->insertBooking($book); 
            	$bookingID = $this->db->insert_id();
            	
            	$this->session->set_userdata('bookingID', $bookingID);
            	
				for($j=0; $j<count($booking); $j++)
				{
				    $booking[$j]['bookingID'] = $bookingID;
				    $result = $this->BookingDetailsModel->insertBookingDetails($booking[$j]);
				    
				    //$result1 = $this->EventDetailsModel->updateEventDetails($event[$j], $booking[$j]['eventDetailsID']); 
				}
				
				$bookingMail = array($book, $bookingMail, $participantMail);
				$this->sendMail($bookingMail, '2');
			    
			    echo "<script>
							window.location.href='".base_url()."index.php/payment/PaymentController';
						</script>";
            }
            else
            {
                echo "<script>alert('Please Enter All Details...');
								window.location.href='".base_url()."index.php/workshopBooking/WorkshopBookingController';
							</script>";
            }
    	}
    	
    	public function sendMail($prop, $flag)
        { 
            if($flag == '1')
            {
                $to         = 'deshmukh57@yahoo.in,usp.eventbook@gmail.com,uskpune.razorpay@gmail.com,'.$prop['mailID'];
                $subject    = "Urban Sketchers Pune Participant Registration";
                
                $status  = "Unkown";
                $payment = "Unkown";
                
                if($prop['status'] == '0')
                {
                    $status = "Pending";
                    $additionalMessage = "You can't use this ID for Workshop Bookings. Please register again with successful transaction.";
                }
                else if($prop['status'] == '1')
                {
                    $status = "Booked";
                    $additionalMessage = "Please Use this Registration ID for further Workshop Booking.";
                }
                
                if($prop['payment'] == '1')
                {
                    $payment = "Online Payment";
                }
                else if($prop['payment'] == '0')
                {
                    $payment = "Payment Issue";
                }
                
                $message = "
                <html>
                    <head>
                        <title>Urban Sketchers Pune Participant Registration Details</title>
                        <style>
                            table
                            {
                                width: 100%;
                            }
                            
                            th
                            {
                                border: 1px solid gray;
                                padding: 10px;
                                /*color: #FFF;
                                background: #0160aa;*/
                            }
                            
                            td
                            {
                                border: 1px solid gray;
                                padding: 10px;
                            }
                            
                            .colorHeading
                            {
                                background: #333333;
                            }
                        </style>
                    </head>
                    <body>
                        <table>
                            <tr>
                                <th colspan='2' class='colorHeading'></th>
                            </tr>
                            <tr>
                                <td colspan='2'>
                                    <center>
                                        <img alt='Logo' src='https://nandd.co/urbansketchers/backoffice/assets/img/mainLogo.png'/>
                                        <h3>Urban Sketchers Pune Participant Registration Details</h3>
                                    </center>
                                </td>
                            </tr>
                            <tr>
                                <th style='width:50%'>Participant ID : </th>
                                <td style='width:50%'>USP".$prop['participantID']."</td>
                            </tr>
    						<tr>
                                <th>First Name : </th>
                                <td>".$prop['firstName']."</td>
                            </tr>
                            <tr>
                                <th>Last Name : </th>
                                <td>".$prop['lastName']."</td>
                            </tr>
    						<tr>
                                <th>Contact Number : </th>
                                <td>".$prop['contactNumber']."</td>
                            </tr>
    						<tr>    
                                <th>Email Address : </th>
                                <td>".$prop['mailID']."</td>
                            </tr>
                            <tr>
                                <th>Current City : </th>
                                <td>".$prop['groupBranchCity']."</td>
                            </tr>
    						<tr>    
                                <th>Country : </th>
                                <td>".$prop['address']."</td>
                            </tr>
                            <tr>
                                <th>Amount : </th>
                                <td>500</td>
                            </tr>
                            <tr>
                                <th>Booking Status : </th>
                                <td>".$status." (".$additionalMessage.")</td>
                            </tr>
    						<tr>
                                <th>Payment Status : </th>
                                <td>".$payment."</td>
                            </tr>
                            <tr>
                                <th colspan='2' class='colorHeading'></th>
                            </tr>
                        </table>
                    </body>
                </html>
                ";
            }
            else if($flag == '2')
            {
                $to         = 'deshmukh57@yahoo.in,usp.eventbook@gmail.com,uskpune.razorpay@gmail.com,'.$prop['2']['mailID'];
                $subject    = "Urban Sketchers Pune Workshop Booking Details";
                $message = "
                <html>
                    <head>
                        <title>Urban Sketchers Pune Workshop Booking Details</title>
                        <style>
                            
                            table
                            {
                                width: 100%;
                            }
                            
                            th
                            {
                                border: 1px solid gray;
                                padding: 10px;
                                /*color: #FFF;
                                background: #0160aa;*/
                            }
                            
                            td
                            {
                                border: 1px solid gray;
                                padding: 10px;
                            }
                            
                            .colorHeading
                            {
                                background: #333333;
                            }
                        </style>
                    </head>
                    <body>
                        <table>";
                        
                        $status  = "Unkown";
                        $payment = "Unkown";
                        
                        if($prop['0']['status'] == '0')
                        {
                            $status = "Pending";
                            $additionalMessage = "You can't use this ID for Workshop Bookings. Please register again with successful transaction.";
                        }
                        else if($prop['0']['status'] == '1')
                        {
                            $status = "Booked";
                            $additionalMessage = "Please Use this Registration ID for further Workshop Booking.";
                        }
                        
                        if($prop['0']['payment'] == '1')
                        {
                            $payment = "Online Payment";
                        }
                        else if($prop['0']['payment'] == '0')
                        {
                            $payment = "Payment Issue";
                        }
                        
                        $BookingDetails = "";
                        
                        if(count($prop['1']) > 0)
                        {
                            for($j=0; $j < count($prop['1']); $j++)
    				        { 
    				            if($prop['1'][$j]['day1Morning']=='1')
    				            {
    				                $BookingDetails .= "Day 1 (".$prop['1'][$j]['InstructorName']." - Morning Batch) : Rs. 1500/-<br>";
    				            }
    				            
    				            if($prop['1'][$j]['day1Evening']=='1')
    				            {
    				                $BookingDetails .= "Day 1 (".$prop['1'][$j]['InstructorName']." - Afternoon Batch) : Rs. 1500/-<br>";
    				            }
    				            
    				            if($prop['1'][$j]['day2Morning']=='1')
    				            {
    				                $BookingDetails .= "Day 2 (".$prop['1'][$j]['InstructorName']." - Morning Batch) : Rs. 1500/-<br>";
    				            }
    				            
    				            if($prop['1'][$j]['day2Evening']=='1')
    				            {
    				                $BookingDetails .= "Day 2 (".$prop['1'][$j]['InstructorName']." - Afternoon Batch) : Rs. 1500/-<br>";
    				            }
    				            
    				            if($prop['1'][$j]['day3Morning']=='1')
    				            {
    				                $BookingDetails .= "Day 3 (".$prop['1'][$j]['InstructorName']." - Morning Batch) : Rs. 1500/-<br>";
    				            }
    				            
    				            if($prop['1'][$j]['day3Evening']=='1')
    				            {
    				                $BookingDetails .= "Day 3 (".$prop['1'][$j]['InstructorName']." - Afternoon Batch) : Rs. 1500/-<br>";
    				            }
    				        }
                        }
                
                $message .= "
                            <tr>
                                <th colspan='2' class='colorHeading'></th>
                            </tr>
                            <tr>
                                <td colspan='2'>
                                    <center>
                                        <img alt='Logo' src='https://nandd.co/urbansketchers/backoffice/assets/img/mainLogo.png'/>
                                        <h3>Urban Sketchers Pune Workshop Booking Details</h3>
                                    </center>
                                </td>
                            </tr>
                            <tr>
                                <th style='width:50%'>Participant ID : </th>
                                <td style='width:50%'>USP".$prop['2']['participantID']."</td>
                            </tr>
                            <tr>
                                <th>First Name : </th>
                                <td>".$prop['2']['firstName']."</td>
                            </tr>
                            <tr>
                                <th>Last Name : </th>
                                <td>".$prop['2']['lastName']."</td>
                            </tr>
    						<tr>
                                <th>Contact Number : </th>
                                <td>".$prop['2']['contactNumber']."</td>
                            </tr>
    						<tr>    
                                <th>Email Address : </th>
                                <td>".$prop['2']['mailID']."</td>
                            </tr>
                            <tr>
                                <th>Current City : </th>
                                <td>".$prop['2']['groupBranchCity']."</td>
                            </tr>
    						<tr>    
                                <th>Country : </th>
                                <td>".$prop['2']['address']."</td>
                            </tr>
                            <tr>
                                <th>Booking Details : </th>
                                <td>".$BookingDetails."</td>
                            </tr>
                            <tr>
                                <th>Total Amount : </th>
                                <td>".($prop['0']['totalAmount']-500)."</td>
                            </tr>
    						<tr>
                                <th>Booking Status : </th>
                                <td>".$status." (".$additionalMessage.")</td>
                            </tr>
    						<tr>
                                <th>Payment Status : </th>
                                <td>".$payment."</td>
                            </tr>
                            <tr>
                                <th colspan='2' class='colorHeading'></th>
                            </tr>
                        </table>
                    </body>
                </html>
                ";
            }
            
            // Always set content-type when sending HTML email
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            
            // More headers
            //$fromMailID  = $this->session->userdata('fromEmail');
            $fromMailID = "contact@urbansketcherspune.com";
            
            $headers .= "From: ".$fromMailID."" . "\r\n";
            
            $a = mail($to,$subject,$message,$headers);
            
        }
        
    	public function getParticipant()
    	{ 
            $participantID = $this->input->post('id',TRUE); 
            //echo "--".$participantID;exit;
            $data = $this->WorkshopRegistrationWithBookingModel->getParticipant($participantID); //->result();
            //print_r($data); exit;
            
            if(!empty($data))
            {
                $dataWorkshop = $this->WorkshopRegistrationWithBookingModel->getWorkshopRegistrationWithBookingOnParticipantID($participantID);
                //print_r($dataWorkshop); exit;
                if(empty($dataWorkshop))
                {
                    echo json_encode($data);                    
                }
                else if(!empty($dataWorkshop) && $dataWorkshop['0']['payment'] == '0')
                {
                    echo json_encode($data);                    
                }
                else
                {
                    echo json_encode(array('message' => 'AlreadyBooked'));
                }
            }
            else
            {
                echo json_encode(array('message' => 'NotFound'));
            }
        }
	}
    
?>
