<?php
    defined('BASEPATH') OR exit('No direct script access allowed');
    
    class WorkshopRegistrationController extends CI_Controller 
    {
        public function __construct() 
        {
            parent::__construct();
            $this->load->library('session');
            $this->load->helper('url');
            
			$this->load->database();
			$this->load->model('eventDetails/eventDetailsModel');
			$this->load->model('workshopRegistration/WorkshopRegistrationModel');
        }
        
    	public function index()
    	{
			$eventDetailsResult = $this->eventDetailsModel->getEventDetails();
    	    $this->load->view('workshopRegistration/WorkshopRegistration', ['eventDetailsResult'=>$eventDetailsResult]);
    	}
		
		public function insertWorkshopRegistration()
    	{
            if(
                $this->input->post('txtFullName') !="" && 
				$this->input->post('txtContactNumber') !="" && 
				$this->input->post('txtMailID') !="" && 
				$this->input->post('txtAddress') !="" && 
				$this->input->post('txtGroupBranchCity') !=""
			)
			{
			    $prop = array( 
								'fullName' 	        => $this->input->post('txtFullName'),
								'contactNumber'	    => $this->input->post('txtContactNumber'),
								'mailID'		    => $this->input->post('txtMailID'),
								'address' 	        => $this->input->post('txtAddress'),
								'groupBranchCity' 	=> $this->input->post('txtGroupBranchCity')
							);
				
				$result = $this->WorkshopRegistrationModel->insertWorkshopRegistration($prop); 
				
				if($result == 1)
				{
				   echo "<script>alert('Record inserted successfully...');
							window.location.href='".base_url()."index.php/workshopRegistration/WorkshopRegistrationController';
						</script>";
				}
				else
                {
                    echo "<script>alert('Something went wrong please try again...');
    								window.location.href='".base_url()."index.php/workshopRegistration/WorkshopRegistrationController';
    							</script>";
                }
            }
            else
            {
                echo "<script>alert('Please Enter All Details...');
								window.location.href='".base_url()."index.php/workshopRegistration/WorkshopRegistrationController';
							</script>";
            }
    	}
	}
    
?>