<?php
    defined('BASEPATH') OR exit('No direct script access allowed');
    
    class BookingDetailsModel extends CI_Model 
    {
        public function insertBookingDetails($prop)
        {
            return $this->db->insert('tblbookingdetails', $prop);
        }
        
        function getBooking($prop)
        {
            $this->db->where('bookingID', $prop);
            $this->db->select("tblbooking.*, tblparticipant.*, tblbooking.payment as bookingpayment, tblbooking.status as bookingstatus");
            $this->db->from("tblbooking");
            $this->db->join('tblparticipant', 'tblbooking.participantID = tblparticipant.participantID', 'left');
            $query = $this->db->get();
            return $query->result_array();
        }
        
        function getParticipant($prop)
        {
            $this->db->where('participantID', $prop);
            $this->db->select("*");
            $this->db->from("tblparticipant");
            $query = $this->db->get();
            return $query->result_array();
        }
        
        
        function getBookingDetails($prop)
        {
            $this->db->where('bookingID', $prop);
            $this->db->select("tblbookingdetails.*, tbleventdetails.InstructorName");
            $this->db->from("tblbookingdetails");
            $this->db->join('tbleventdetails', 'tblbookingdetails.eventDetailsID = tbleventdetails.eventDetailsID', 'left');
            $query = $this->db->get();
            return $query->result_array();
        }
        
        function updateBookingPaymentStatus($bookingID, $paymentStatus)
        {
            $prop = array(
                            'status'    => $paymentStatus,
                            'payment'   => $paymentStatus
                        );
            $this->db->where('bookingID', $bookingID);
    		return $this->db->update('tblbooking', $prop);
        }
        
        function updateParticipantPaymentStatus($participantID, $paymentStatus)
        {
            $prop = array(
                            'status'    => $paymentStatus,
                            'payment'   => $paymentStatus
                        );
            $this->db->where('participantID', $participantID);
    		return $this->db->update('tblparticipant', $prop);
        }
    }
?>